/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.autoplot.AutoplotUI;
import org.autoplot.datasource.WindowManager;
import org.autoplot.dom.Annotation;
import org.autoplot.jythonsupport.ui.JLinkyLabel;
import org.das2.components.GrannyTextEditor;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.graph.AnchorPosition;
import org.das2.graph.AnchorType;
import org.das2.graph.BorderType;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;

public class AddAnnotationDialog
extends JPanel {
    private static Logger logger = Logger.getLogger("autoplot.gui");
    EnumerationEditor anchorPositionEnumEditor;
    private JPanel anchorPositionPanel;
    private EnumerationEditor borderTypeEnumEditor;
    private JPanel borderTypePanel;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField jTextField1;
    private JPanel linkyLabelPanel;
    private JCheckBox pointAtCB;
    private JPanel previewPanel;
    private JTextField xDatumField;
    private JTextField yDatumField;
    private BindingGroup bindingGroup;
    Datum x = null;
    Datum y = null;

    public AddAnnotationDialog() {
        this.initComponents();
        this.anchorPositionEnumEditor = new EnumerationEditor();
        this.anchorPositionEnumEditor.setValue((Object)AnchorPosition.NE);
        this.anchorPositionPanel.setLayout(new BorderLayout());
        this.anchorPositionPanel.add(this.anchorPositionEnumEditor.getCustomEditor(), "Center");
        this.borderTypeEnumEditor.setValue((Object)BorderType.ROUNDED_RECTANGLE);
        this.borderTypePanel.add(this.borderTypeEnumEditor.getCustomEditor());
        JLinkyLabel ll = new JLinkyLabel(null, "<html>This <a href='https://github.com/autoplot/documentation/blob/master/docs/annotations.md'>web page</a> shows how the annotations are controlled.");
        this.linkyLabelPanel.add((Component)ll, "Center");
        this.validate();
    }

    public String getText() {
        return this.jTextField1.getText();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.borderTypeEnumEditor = new EnumerationEditor();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.pointAtCB = new JCheckBox();
        this.xDatumField = new JTextField();
        this.yDatumField = new JTextField();
        this.jLabel1 = new JLabel();
        this.anchorPositionPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.borderTypePanel = new JPanel();
        this.linkyLabelPanel = new JPanel();
        this.jButton1 = new JButton();
        this.previewPanel = new JPanel();
        this.jTextField1.setText("Annotation 1");
        this.jLabel2.setText("Annotation Text: ");
        this.pointAtCB.setText("Point At:");
        this.pointAtCB.setToolTipText("Point at this data location, and annotation will move with data.");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.pointAtCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.xDatumField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.pointAtCB, (Property)ELProperty.create((String)"${selected}"), (Object)this.yDatumField, (Property)BeanProperty.create((String)"enabled"));
        this.bindingGroup.addBinding((Binding)binding);
        this.jLabel1.setText("Position:");
        this.jLabel1.setToolTipText("Position of anchor relative to corner or data point");
        GroupLayout anchorPositionPanelLayout = new GroupLayout(this.anchorPositionPanel);
        this.anchorPositionPanel.setLayout(anchorPositionPanelLayout);
        anchorPositionPanelLayout.setHorizontalGroup(anchorPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        anchorPositionPanelLayout.setVerticalGroup(anchorPositionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 15, Short.MAX_VALUE));
        this.jLabel3.setText("Border Type:");
        this.borderTypePanel.setLayout(new BorderLayout());
        this.linkyLabelPanel.setToolTipText("");
        this.linkyLabelPanel.setLayout(new BorderLayout());
        this.jButton1.setText("...");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddAnnotationDialog.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout previewPanelLayout = new GroupLayout(this.previewPanel);
        this.previewPanel.setLayout(previewPanelLayout);
        previewPanelLayout.setHorizontalGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        previewPanelLayout.setVerticalGroup(previewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 132, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.previewPanel, -1, -1, Short.MAX_VALUE).addComponent(this.linkyLabelPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 23, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.borderTypePanel, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.pointAtCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xDatumField, -2, 148, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yDatumField, -2, 124, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.anchorPositionPanel, -1, -1, Short.MAX_VALUE))).addGap(0, 214, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pointAtCB).addComponent(this.xDatumField, -2, -1, -2).addComponent(this.yDatumField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.anchorPositionPanel, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.borderTypePanel, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.previewPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.linkyLabelPanel, -2, 20, -2).addContainerGap()));
        this.bindingGroup.bind();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        GrannyTextEditor edit = AutoplotUI.newGrannyTextEditorWithMacros();
        edit.setValue(this.jTextField1.getText());
        if (0 == WindowManager.showConfirmDialog((Component)this, (Object)edit, (String)"Granny Text Editor", (int)2)) {
            this.jTextField1.setText(edit.getValue());
        }
    }

    void configure(Annotation ann) {
        ann.setText(this.jTextField1.getText());
        ann.setAnchorType(this.pointAtCB.isSelected() ? AnchorType.PLOT : AnchorType.CANVAS);
        ann.setAnchorPosition((AnchorPosition)this.anchorPositionEnumEditor.getValue());
        ann.setBorderType((BorderType)this.borderTypeEnumEditor.getValue());
        if (ann.getBorderType() == BorderType.NONE) {
            ann.setBackground(new Color(0, 0, 0, 0));
            ann.setOverrideColors(true);
        }
        if (this.pointAtCB.isSelected()) {
            try {
                Datum x = this.x.getUnits().parse(this.xDatumField.getText());
                ann.setPointAtX(x);
                ann.setXrange(new DatumRange(x, x));
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            try {
                Datum y = this.y.getUnits().parse(this.yDatumField.getText());
                ann.setPointAtY(y);
                ann.setYrange(new DatumRange(y, y));
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            ann.setShowArrow(true);
        }
    }

    void setPointAtX(Datum invTransform) {
        this.xDatumField.setText(invTransform.toString());
        this.x = invTransform;
        this.pointAtCB.setEnabled(true);
        if (this.y != null) {
            this.pointAtCB.setEnabled(true);
        }
    }

    void setPointAtY(Datum invTransform) {
        this.yDatumField.setText(invTransform.toString());
        this.y = invTransform;
        if (this.x != null) {
            this.pointAtCB.setEnabled(true);
        }
    }
}

